/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.tileentities.TileEntityGrave;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInventoryMessage
extends AbstractColonyServerMessage {
    private String name;
    private InventoryType inventoryType;
    private int entityID;
    private BlockPos tePos;

    public OpenInventoryMessage() {
    }

    public OpenInventoryMessage(IColonyView colony, @NotNull String name, int id) {
        super(colony);
        this.inventoryType = InventoryType.INVENTORY_CITIZEN;
        this.name = name;
        this.entityID = id;
    }

    public OpenInventoryMessage(IBuildingView building) {
        super(building.getColony());
        this.inventoryType = InventoryType.INVENTORY_CHEST;
        this.name = "";
        this.tePos = building.getID();
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.inventoryType = InventoryType.values()[buf.readInt()];
        this.name = buf.func_150789_c(Short.MAX_VALUE);
        switch (this.inventoryType) {
            case INVENTORY_CITIZEN: {
                this.entityID = buf.readInt();
                break;
            }
            case INVENTORY_CHEST: 
            case INVENTORY_FIELD: {
                this.tePos = buf.func_179259_c();
            }
        }
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.inventoryType.ordinal());
        buf.func_180714_a(this.name);
        switch (this.inventoryType) {
            case INVENTORY_CITIZEN: {
                buf.writeInt(this.entityID);
                break;
            }
            case INVENTORY_CHEST: 
            case INVENTORY_FIELD: {
                buf.func_179255_a(this.tePos);
            }
        }
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ServerPlayerEntity player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        switch (this.inventoryType) {
            case INVENTORY_CITIZEN: {
                this.doCitizenInventory(player);
                break;
            }
            case INVENTORY_CHEST: {
                this.doHutInventory(player, colony);
                break;
            }
            case INVENTORY_FIELD: {
                this.doFieldInventory(player);
                break;
            }
        }
    }

    private void doCitizenInventory(ServerPlayerEntity player) {
        @Nullable AbstractEntityCitizen citizen = (AbstractEntityCitizen)CompatibilityUtils.getWorldFromEntity((Entity)player).func_73045_a(this.entityID);
        if (citizen != null) {
            if (!StringUtils.func_151246_b((String)this.name)) {
                citizen.getInventoryCitizen().setCustomName(this.name);
            }
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)citizen, packetBuffer -> packetBuffer.func_150787_b(citizen.getCitizenColonyHandler().getColonyId()).func_150787_b(citizen.getCivilianID()));
        }
    }

    private void doHutInventory(ServerPlayerEntity player, IColony colony) {
        TileEntity tileEntity = BlockPosUtil.getTileEntity(player.field_70170_p, this.tePos);
        if (tileEntity instanceof TileEntityRack || tileEntity instanceof TileEntityGrave) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)((INamedContainerProvider)tileEntity), packetBuffer -> packetBuffer.func_150787_b(colony.getID()).func_179255_a(tileEntity.func_174877_v()));
        }
    }

    private void doFieldInventory(ServerPlayerEntity player) {
        @NotNull ScarecrowTileEntity scarecrowTileEntity = (ScarecrowTileEntity)BlockPosUtil.getTileEntity(CompatibilityUtils.getWorldFromEntity((Entity)player), this.tePos);
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)scarecrowTileEntity);
    }

    private static enum InventoryType {
        INVENTORY_CITIZEN,
        INVENTORY_CHEST,
        INVENTORY_FIELD;

    }
}

